package examples.entity.intro;

import java.util.Iterator;
import java.util.List;

import javax.naming.*;

/**
 * Sample client code for an Account entity that is accessed through
 * a stateless session bean.
 */
public class Client {
    
    public static void main(String[] args)  {       
        Bank bank = null;
        Account account = null;
        int accountNumber = 0;
        try {
            /*
             * Get a reference to the Account Session Object 
             */
            Context ctx = new InitialContext(System.getProperties());
            bank = (Bank)ctx.lookup(Bank.class.getName());
            
            /*
             * Let's find existing accounts in the bank...
             */
            List<Account> accounts = bank.listAccounts();  
         
            /* 
             * ... and print them to the screen 
             */
            System.out.println("--- Accounts in this bank ---");
            for(Iterator iter = accounts.iterator(); iter.hasNext();) {
                System.out.println(iter.next());
            }
            System.out.println("-----------------------------");
            
            /*
             * Open an account and get a local copy of the account object 
             * We can access the object in the bank by using our account number.
             */
            account = bank.openAccount("Ben Johnson");
            accountNumber = account.accountNumber;
            
            /*
             * Call the balance() method, and print it
             */
            System.out.println("Initial Balance = " + 
                    bank.getBalance(accountNumber));

            /*
             * Deposit $100 into the account
             */
            bank.deposit(accountNumber,100);

            /*
             * Retrieve the resulting balance both from 
             * the original and the local copy
             */
            System.out.println("After depositing $100, the account balance is: $"
                    + bank.getBalance(accountNumber));
            System.out.println("Sadly, the local account balance still is: $"
                    + account.balance);

            /*
             * Try to withdraw $150
             */
            System.out.println("Now trying to withdraw $150, which is more than is currently available.");
            int withdrawn = bank.withdraw(accountNumber,150);
            if(withdrawn != 150) 
                System.out.println("No success...");
            else
                System.out.println("Success");
            
//            account.balance += 10000;
//            bank.update(account);
//            
//            System.out.println("After depositing $10,000 locally and updating, the account balance is: $"
//                    + bank.getBalance(accountNumber));
            
        } catch (Exception e) {
            System.out.println("Message: " + e.getMessage());
        } finally {
            /*
             * Destroy the Entity permanently
             
            try {
                if (account != null) {
                    System.out.println("Destroying account..");
                    bank.close(accountNumber);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            */
        }
    }
}
